using System;
using System.Collections;
using System.Linq;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;

namespace Zadaci
{
    [Flags]
    public enum KrvnaGrupa : byte
    {
        O, A, B, AB,
    };
    public class Zaliharnica
    {
        public uint a = 0,
            b = 0,
            ab = 0,
            o = 0;
        public Zaliharnica(uint O, uint A, uint B, uint AB)
        {
            a = A;
            b = B;
            ab = AB;
            o = O;
        }
        public void oduzeti(Pacijent p)
        {
            switch (p.grupa)
            {
                case KrvnaGrupa.A:
                    while ((a > 0  || o > 0) && p.kol != 0)
                    {
                        if (a > 0)
                            a--;
                        else if (o > 0)
                            o--;
                        p.kol--;
                    }
                    break;
                case KrvnaGrupa.B:
                    while ((b > 0 || o > 0) && p.kol > 0)
                    {
                        if (b > 0)
                            b--;
                        else if (o > 0)
                            o--;
                        p.kol--;
                    }

                    break;
                case KrvnaGrupa.AB:
                    while ((b > 0 || o > 0 || ab > 0) && p.kol > 0)
                    {
                        if (a > 0)
                            a--;
                        else if (b > 0)
                            b--;
                        else if (ab > 0)
                            ab--;
                        else if (o > 0)
                            o--;
                        p.kol--;
                    }
                    break;
                case KrvnaGrupa.O:
                    while (o > 0 || p.kol > 0)
                    {
                        if(o > 0)
                        {
                            o--;
                        }
                        p.kol--;
                    }
                    break;
            }
            if (p.kol != 0) Moguce = false;
        }
        public bool Moguce = true;
    }
    public class Pacijent
    {
        public KrvnaGrupa grupa = KrvnaGrupa.A;
        public uint kol;
        public Pacijent(KrvnaGrupa gr, uint k)
        {
            kol = k;
            grupa = gr;
        }

        public static int Compare(Pacijent x, Pacijent y)
        {
            return x.grupa.CompareTo(y.grupa);
        }
    }
    public class Program
    {

        public static KrvnaGrupa rts(string gr)
        {
            switch (gr)
            {
                //kesovati ovo mozda kojim slucajem
                default: return KrvnaGrupa.A;
                case "A":
                    return KrvnaGrupa.A;
                case "B":
                    return KrvnaGrupa.B;
                case "AB":
                    return KrvnaGrupa.AB;
                case "O":
                    return KrvnaGrupa.O;
            }
        }
        static void Main()
        {
            ushort n = ushort.Parse(Console.ReadLine());
            string[] zalihe = Console.ReadLine().Split();
            List<Pacijent> pacijenti = new List<Pacijent>();
            List<Pacijent> pacijenti_og = new List<Pacijent>();
            for (ushort i = 0; i < n; i++)
            {
                string[] pp = Console.ReadLine().Split();
                pacijenti.Add(new Pacijent(rts(pp[0]), uint.Parse(pp[1])
                    ));
            }
            Zaliharnica zal = new Zaliharnica(
                uint.Parse(zalihe[0]),
                uint.Parse(zalihe[1]),
                uint.Parse(zalihe[2]),
                uint.Parse(zalihe[3]));
            pacijenti_og = pacijenti;
            pacijenti.Sort(Pacijent.Compare);

            foreach (Pacijent p in pacijenti)
            {
                if (!zal.Moguce) break;
                zal.oduzeti(p);
            }

            switch (zal.Moguce)
            {
                case true:
                    Console.WriteLine("moguce");
                    break;
                case false:
                    Console.WriteLine("nemoguce");
                    break;
            }
        }
    }
}